/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.article.core.searchparams.ArticleCategoryMappingSearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategoryMapping;
import net.guerlab.smart.article.service.handlers.ArticleCategoryDeleteAfterHandler;
import net.guerlab.smart.article.service.mapper.ArticleCategoryMappingMapper;
import net.guerlab.smart.article.service.service.ArticleCategoryMappingService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ArticleCategoryMappingServiceImpl
implements ArticleCategoryMappingService,
ArticleCategoryDeleteAfterHandler {
    private ArticleCategoryMappingMapper mapper;

    @Override
    public Collection<ArticleCategoryMapping> findList(ArticleCategoryMappingSearchParams searchParams) {
        return this.mapper.selectList((Wrapper)this.getQueryWrapper(searchParams));
    }

    @Override
    public void save(Collection<ArticleCategoryMapping> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List waitSaves = list.stream().filter(this::saveFilter).collect(Collectors.toList());
        if (waitSaves.isEmpty()) {
            return;
        }
        this.mapper.replaceInsertList(waitSaves);
    }

    private boolean saveFilter(ArticleCategoryMapping item) {
        return item != null && NumberHelper.allGreaterZero((Number[])new Number[]{item.getArticleId(), item.getArticleCategoryId()});
    }

    @Override
    public void delete(ArticleCategoryMappingSearchParams searchParams) {
        this.mapper.delete((Wrapper)this.getQueryWrapper(searchParams));
    }

    @Override
    public void articleCategoryDeleteAfterHandler(Long articleCategoryId) {
        if (!NumberHelper.greaterZero((Number)articleCategoryId)) {
            return;
        }
        ArticleCategoryMappingSearchParams searchParams = new ArticleCategoryMappingSearchParams();
        searchParams.setArticleCategoryId(articleCategoryId);
        this.delete(searchParams);
    }

    private QueryWrapper<ArticleCategoryMapping> getQueryWrapper(ArticleCategoryMappingSearchParams searchParams) {
        QueryWrapper wrapper = new QueryWrapper();
        SearchParamsUtils.handler((AbstractSearchParams)searchParams, (Object)wrapper);
        return wrapper;
    }

    @Autowired
    public void setMapper(ArticleCategoryMappingMapper mapper) {
        this.mapper = mapper;
    }
}

