/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.searchparams.ArticleCategoryMappingSearchParams;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.entity.ArticleCategoryMapping;
import net.guerlab.smart.article.service.service.AbstractArticleService;
import net.guerlab.smart.article.service.service.ArticleCategoryMappingService;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.commons.dto.Convert;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractArticleServiceImpl<E extends Convert<ArticleDTO>, M extends BaseMapper<E>>
extends BaseServiceImpl<E, Long, M, ArticleSearchParams>
implements AbstractArticleService<E> {
    private ArticleCategoryService categoryService;
    private ArticleCategoryMappingService mappingService;

    @Override
    public final Collection<E> queryAll(ArticleSearchParams searchParams) {
        if (this.interceptQuery(searchParams)) {
            return Collections.emptyList();
        }
        return this.selectAll((AbstractSearchParams)searchParams);
    }

    @Override
    public final ListObject<E> queryPage(ArticleSearchParams searchParams) {
        if (this.interceptQuery(searchParams)) {
            return ListObject.empty();
        }
        return this.selectPage((AbstractSearchParams)searchParams);
    }

    @Override
    public final int queryCount(ArticleSearchParams searchParams) {
        if (this.interceptQuery(searchParams)) {
            return 0;
        }
        return this.selectCount((AbstractSearchParams)searchParams);
    }

    private boolean interceptQuery(ArticleSearchParams searchParams) {
        Collection<Long> categoryIds = this.findCategoryIds(searchParams);
        if (categoryIds == null) {
            return false;
        }
        if (categoryIds.isEmpty()) {
            return true;
        }
        ArticleCategoryMappingSearchParams mappingSearchParams = new ArticleCategoryMappingSearchParams();
        mappingSearchParams.setArticleCategoryIds(categoryIds);
        mappingSearchParams.setArticleIds(searchParams.getArticleIds());
        List articleIds = CollectionUtil.toList(this.getMappingService().findList(mappingSearchParams), ArticleCategoryMapping::getArticleId);
        searchParams.setArticleIds((Collection)articleIds);
        return articleIds.isEmpty();
    }

    private Collection<Long> findCategoryIds(ArticleSearchParams searchParams) {
        Long articleCategoryId = searchParams.getArticleCategoryId();
        String articleCategoryType = StringUtils.trimToNull((String)searchParams.getArticleCategoryType());
        searchParams.setArticleCategoryId(null);
        searchParams.setArticleCategoryType(null);
        if (!NumberHelper.greaterZero((Number)articleCategoryId) && articleCategoryType == null) {
            return null;
        }
        ArticleCategorySearchParams categorySearchParams = new ArticleCategorySearchParams();
        categorySearchParams.setArticleCategoryId(articleCategoryId);
        categorySearchParams.setArticleCategoryType(articleCategoryType);
        return CollectionUtil.toList((Collection)this.getCategoryService().selectAll((AbstractSearchParams)categorySearchParams), ArticleCategory::getArticleCategoryId);
    }

    protected ArticleCategoryService getCategoryService() {
        return this.categoryService;
    }

    protected ArticleCategoryMappingService getMappingService() {
        return this.mappingService;
    }

    @Autowired
    public void setCategoryService(ArticleCategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @Autowired
    public void setMappingService(ArticleCategoryMappingService mappingService) {
        this.mappingService = mappingService;
    }
}

