/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.service;

import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 文章分类
 *
 * @author guer
 */
public interface ArticleService extends AbstractArticleService<Article>, BaseService<Article, Long, ArticleSearchParams> {

    /**
     * 增加阅读量
     *
     * @param articleId
     *         文章ID
     */
    void addViewNumber(Long articleId);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<Article> getEntityClass() {
        return Article.class;
    }
}
