/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * 文章配置服务
 *
 * @author guer
 */
public interface ArticleConfigService {

    /**
     * key最大长度
     */
    int KEY_MAX_LENGTH = 100;

    /**
     * 值最大长度
     */
    int VALUE_MAX_LENGTH = 255;

    /**
     * 查询单个配置
     *
     * @param key
     *         配置key
     * @return 配置值
     */
    String findOne(String key);

    /**
     * 查询配置是否匹配
     *
     * @param key
     *         配置key
     * @param value
     *         配置值
     * @return 是否匹配
     */
    default boolean match(String key, String value) {
        return value != null && Objects.equals(value, findOne(key));
    }

    /**
     * 查询多个key
     *
     * @param keys
     *         配置key列表
     * @return 配置值表
     */
    Map<String, String> findMap(Collection<String> keys);

    /**
     * 查询多个key
     *
     * @param keys
     *         配置key列表
     * @return 配置值表
     */
    default Map<String, String> findMap(String... keys) {
        return findMap(Arrays.asList(keys));
    }

    /**
     * 查询全部
     *
     * @return 配置值表
     */
    Map<String, String> findAll();

    /**
     * 保存配置
     *
     * @param configs
     *         配置列表
     */
    void save(Map<String, String> configs);

    /**
     * 删除配置
     *
     * @param keys
     *         配置key列表
     */
    void delete(Collection<String> keys);

    /**
     * 删除配置
     *
     * @param keys
     *         配置key列表
     */
    default void delete(String... keys) {
        delete(Arrays.asList(keys));
    }
}
