/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.service;

import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 文章分类服务
 *
 * @author guer
 */
public interface ArticleCategoryService extends BaseService<ArticleCategory, Long, ArticleCategorySearchParams> {

    /**
     * 分类名称最大长度
     */
    int CATEGORY_NAME_MAX_LENGTH = 100;

    /**
     * 页面类型最大长度
     */
    int PAGE_TYPE_MAX_LENGTH = 100;

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<ArticleCategory> getEntityClass() {
        return ArticleCategory.class;
    }
}
