/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.service;

import net.guerlab.smart.article.core.searchparams.ArticleCategoryMappingSearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategoryMapping;

import java.util.Collection;

/**
 * 文章分类映射服务
 *
 * @author guer
 */
public interface ArticleCategoryMappingService {

    /**
     * 通过搜索参数查询文章分类映射列表
     *
     * @param searchParams
     *         搜索参数
     * @return 文章分类映射列表
     */
    Collection<ArticleCategoryMapping> findList(ArticleCategoryMappingSearchParams searchParams);

    /**
     * 保存文章分类映射列表
     *
     * @param list
     *         文章分类映射列表
     */
    void save(Collection<ArticleCategoryMapping> list);

    /**
     * 通过搜索参数删除文章分类映射
     *
     * @param searchParams
     *         搜索参数
     */
    void delete(ArticleCategoryMappingSearchParams searchParams);
}
