/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文章分类映射
 *
 * @author guer
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("article_category_mapping")
public class ArticleCategoryMapping {

    /**
     * 文章ID
     */
    private Long articleId;

    /**
     * 文章分类ID
     */
    private Long articleCategoryId;
}
