/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.spring.commons.dto.DefaultConvert;

/**
 * 文章分类
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("article_category")
public class ArticleCategory extends BaseOrderEntity<ArticleCategory> implements DefaultConvert<ArticleCategoryDTO> {

    /**
     * 默认文章分类类型
     */
    public static final String DEFAULT_ARTICLE_CATEGORY_TYPE = "general";

    /**
     * 文章分类ID
     */
    @TableId
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    private String articleCategoryType;

    /**
     * 封面URL
     */
    private String coverUrl;

    /**
     * 上级ID
     */
    @TableField(value = "parentId", updateStrategy = FieldStrategy.NEVER)
    private Long parentId;

    /**
     * 启用标志
     */
    private Boolean enabled;

    /**
     * 显示标志
     */
    private Boolean display;

    /**
     * 列表页类型
     */
    private String listPageType;

    /**
     * 详情页类型
     */
    private String detailPageType;
}
