/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.eneity.Attachments;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.domain.MultiId;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.commons.dto.Convert;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 文章
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("article_article")
public class Article extends BaseOrderEntity<Article> implements Convert<ArticleDTO> {

    /**
     * 文章ID
     */
    @TableId
    private Long articleId;

    /**
     * 唯一key
     */
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    private String articleCategoryType;

    /**
     * 次要文章分类ID列表
     */
    private MultiId secondaryArticleCategoryIds;

    /**
     * 文章分类ID列表
     */
    private MultiId articleCategoryIds;

    /**
     * 标题
     */
    private String title;

    /**
     * seo-关键词
     */
    private String keywords;

    /**
     * seo-页面描述
     */
    private String description;

    /**
     * 封面URL
     */
    private String coverUrl;

    /**
     * 是否有封面
     */
    private Boolean hasCoverUrl;

    /**
     * 作者
     */
    private String author;

    /**
     * 发布时间
     */
    private LocalDateTime releaseTime;

    /**
     * 简介
     */
    private String synopsis;

    /**
     * 内容
     */
    private String content;

    /**
     * 已发布标志
     */
    private Boolean published;

    /**
     * 原文链接
     */
    private String originalLink;

    /**
     * 总是跳转标志
     */
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    private PublishType publishType;

    /**
     * 计划发布时间
     */
    private LocalDateTime planPublishTime;

    /**
     * 实际发布时间
     */
    private LocalDateTime publishTime;

    /**
     * 新建时间
     */
    @TableField(value = "createTime", updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 附件列表
     */
    private Attachments attachments;

    /**
     * 包含附件标志
     */
    private Boolean hasAttachment;

    /**
     * 审核状态
     */
    private AuditStatus auditStatus;

    /**
     * 阅读量
     */
    @TableField(value = "viewNumber", updateStrategy = FieldStrategy.NEVER)
    private Long viewNumber;

    /**
     * 文章分类列表
     */
    @TableField(exist = false)
    private Collection<ArticleCategory> categories;

    @Override
    public ArticleDTO convert() {
        ArticleDTO dto = new ArticleDTO();

        BeanUtils.copyProperties(this, dto);
        dto.setCategories(BeanConvertUtils.toList(this.categories));
        return dto;
    }
}
