/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.service.crons;

import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 文章计划任务
 *
 * @author guer
 */
@Component
public class ArticleCron {

    private ArticleService service;

    /**
     * 发布计划
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void publish() {
        LocalDateTime now = LocalDateTime.now();
        ArticleSearchParams searchParams = new ArticleSearchParams();
        searchParams.setPublishType(PublishType.TIMING);
        searchParams.setPublished(false);
        searchParams.setPlanPublishTimeEndWith(now);
        searchParams.setAuditStatus(AuditStatus.PASS);

        Article update = new Article();
        update.setPublished(true);
        update.setPublishTime(now);

        service.update(update, service.getQueryWrapper(searchParams));
    }

    @Autowired
    public void setService(ArticleService service) {
        this.service = service;
    }
}
