/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import java.time.LocalDateTime;
import java.util.regex.Pattern;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.exception.ArticleCategoryIdInvalidException;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.exception.ArticleTitleInvalidException;
import net.guerlab.smart.article.core.exception.ArticleTitleLengthErrorException;
import net.guerlab.smart.article.core.exception.AuthorLengthErrorException;
import net.guerlab.smart.article.core.exception.OriginalLinkLengthErrorException;
import net.guerlab.smart.article.core.exception.PlanPublishTimeInvalidException;
import net.guerlab.smart.article.core.exception.SynopsisLengthErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyFormatErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyLengthErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyRepeatException;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.mapper.ArticleMapper;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.article.service.service.ArticleCategoryUpdateHandler;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
extends BaseServiceImpl<Article, Long, ArticleMapper>
implements ArticleService,
ArticleCategoryUpdateHandler {
    private ArticleCategoryService categoryService;

    @Override
    public void updateArticleCategory(ArticleCategory articleCategory) {
        String categoryType;
        String categoryName;
        Long categoryId = articleCategory.getArticleCategoryId();
        if (this.refuseUpdateArticleCategory(categoryId, categoryName = StringUtils.trimToNull((String)articleCategory.getArticleCategoryName()), categoryType = StringUtils.trimToNull((String)articleCategory.getArticleCategoryType()))) {
            return;
        }
        Article entity = new Article();
        entity.setArticleCategoryName(categoryName);
        entity.setArticleCategoryType(categoryType);
        ArticleSearchParams searchParams = new ArticleSearchParams();
        searchParams.setArticleCategoryId(categoryId);
        ((ArticleMapper)this.mapper).updateByExampleSelective((Object)entity, this.getExample((AbstractSearchParams)searchParams));
    }

    private boolean refuseUpdateArticleCategory(Long categoryId, String categoryName, String categoryType) {
        return !NumberHelper.greaterZero((Number)categoryId) || categoryName == null && categoryType == null;
    }

    protected void insertBefore(Article entity) {
        PublishType publishType;
        String title = StringUtils.trimToNull((String)entity.getTitle());
        if (title == null) {
            throw new ArticleTitleInvalidException();
        }
        if (title.length() > 255) {
            throw new ArticleTitleLengthErrorException();
        }
        entity.setTitle(title);
        this.setAuthor(entity);
        this.setSynopsis(entity);
        this.setOriginalLink(entity);
        this.setUniqueKey(entity);
        ArticleCategory articleCategory = this.findArticleCategory(entity.getArticleCategoryId());
        entity.setArticleCategoryName(articleCategory.getArticleCategoryName());
        entity.setArticleCategoryType(articleCategory.getArticleCategoryType());
        LocalDateTime now = LocalDateTime.now();
        if (entity.getReleaseTime() == null) {
            entity.setReleaseTime(now);
        }
        if (entity.getAlwaysRedirect() == null) {
            entity.setAlwaysRedirect(false);
        }
        if ((publishType = entity.getPublishType()) == null) {
            publishType = PublishType.AUTOMATIC;
        }
        entity.setPublishType(publishType);
        this.setPublishType(entity, publishType, now);
        entity.setArticleId(this.sequence.nextId());
        entity.setCreateTime(now);
        entity.setUpdateTime(now);
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    private void setUniqueKey(Article entity) {
        String uniqueKey = StringUtils.trimToNull((String)entity.getUniqueKey());
        if (uniqueKey != null) {
            if (uniqueKey.length() > 50) {
                throw new UniqueKeyLengthErrorException();
            }
            if (Pattern.matches("^(-?\\d*)$", uniqueKey)) {
                throw new UniqueKeyFormatErrorException();
            }
            if (this.selectByUniqueKey(uniqueKey) != null) {
                throw new UniqueKeyRepeatException();
            }
        } else {
            uniqueKey = "";
        }
        entity.setUniqueKey(uniqueKey);
    }

    protected void updateBefore(Article entity) {
        String title = StringUtils.trimToNull((String)entity.getTitle());
        if (title != null && title.length() > 255) {
            throw new ArticleTitleLengthErrorException();
        }
        entity.setTitle(title);
        this.setAuthor(entity);
        this.setSynopsis(entity);
        this.setOriginalLink(entity);
        Long articleCategoryId = entity.getArticleCategoryId();
        if (NumberHelper.greaterZero((Number)articleCategoryId)) {
            ArticleCategory articleCategory = this.findArticleCategory(articleCategoryId);
            entity.setArticleCategoryName(articleCategory.getArticleCategoryName());
            entity.setArticleCategoryType(articleCategory.getArticleCategoryType());
        } else {
            entity.setArticleCategoryId(null);
            entity.setArticleCategoryName(null);
            entity.setArticleCategoryType(null);
        }
        PublishType publishType = entity.getPublishType();
        LocalDateTime now = LocalDateTime.now();
        if (publishType != null) {
            this.setPublishType(entity, publishType, now);
        }
        entity.setUpdateTime(now);
    }

    private void setAuthor(Article entity) {
        String author = StringUtils.trimToNull((String)entity.getAuthor());
        if (author != null && author.length() > 100) {
            throw new AuthorLengthErrorException();
        }
        entity.setAuthor(author);
    }

    private void setSynopsis(Article entity) {
        String synopsis = StringUtils.trimToNull((String)entity.getSynopsis());
        if (synopsis != null && synopsis.length() > 255) {
            throw new SynopsisLengthErrorException();
        }
        entity.setSynopsis(synopsis);
    }

    private void setOriginalLink(Article entity) {
        String originalLink = StringUtils.trimToNull((String)entity.getOriginalLink());
        if (originalLink != null && originalLink.length() > 255) {
            throw new OriginalLinkLengthErrorException();
        }
        entity.setOriginalLink(originalLink);
    }

    private void setPublishType(Article entity, PublishType publishType, LocalDateTime now) {
        switch (publishType) {
            case AUTOMATIC: {
                entity.setPlanPublishTime(now);
                entity.setPublishTime(now);
                entity.setPublished(true);
                break;
            }
            case TIMING: {
                LocalDateTime planPublishTime = entity.getPlanPublishTime();
                if (planPublishTime == null) {
                    throw new PlanPublishTimeInvalidException();
                }
                if (planPublishTime.isBefore(now)) {
                    entity.setPublished(true);
                    entity.setPublishTime(now);
                    break;
                }
                entity.setPublishTime(null);
                entity.setPublished(false);
                break;
            }
            case MANUAL: {
                if (entity.getPublished() == null) {
                    entity.setPlanPublishTime(null);
                    entity.setPublishTime(null);
                    break;
                }
                if (entity.getPublished().booleanValue()) {
                    entity.setPlanPublishTime(now);
                    entity.setPublishTime(now);
                    break;
                }
                entity.setPlanPublishTime(now);
                entity.setPublishTime(now);
                break;
            }
        }
    }

    private ArticleCategory findArticleCategory(Long articleCategoryId) {
        if (!NumberHelper.greaterZero((Number)articleCategoryId)) {
            throw new ArticleCategoryIdInvalidException();
        }
        return (ArticleCategory)((Object)this.categoryService.selectByIdOptional(articleCategoryId).orElseThrow(ArticleCategoryInvalidException::new));
    }

    @Autowired
    public void setCategoryService(ArticleCategoryService categoryService) {
        this.categoryService = categoryService;
    }
}

