package net.guerlab.smart.article.service.service;

import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 文章分类服务
 *
 * @author guer
 */
public interface ArticleCategoryService extends BaseService<ArticleCategory, Long> {

    /**
     * 分类名称最大长度
     */
    int CATEGORY_NAME_MAX_LENGTH = 100;

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<ArticleCategory> getEntityClass() {
        return ArticleCategory.class;
    }
}
