package net.guerlab.smart.article.service.service;

import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.platform.server.service.BaseFindService;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.apache.commons.lang3.StringUtils;

/**
 * 抽象文章分类服
 *
 * @author guer
 */
public interface AbstractArticleService<E extends ConvertDTO<ArticleDTO>, PK> extends BaseFindService<E, PK> {

    /**
     * 数值正则表达式
     */
    String NUMBER_REG = "^(-?\\d*)$";

    /**
     * 标题最大长度
     */
    int TITLE_MAX_LENGTH = 255;

    /**
     * 唯一key最大长度
     */
    int UNIQUE_KEY_MAX_LENGTH = 50;

    /**
     * 简介最大长度
     */
    int SYNOPSIS_MAX_LENGTH = 255;

    /**
     * 原文链接最大长度
     */
    int ORIGINAL_LINK_MAX_LENGTH = 255;

    /**
     * 作者最大长度
     */
    int AUTHOR_MAX_LENGTH = 100;

    /**
     * 通过唯一key查询文章
     *
     * @param uniqueKey
     *         唯一key
     * @return 文章
     */
    default E selectByUniqueKey(String uniqueKey) {
        String key = StringUtils.trimToNull(uniqueKey);
        if (key == null) {
            return null;
        }

        ArticleSearchParams searchParams = new ArticleSearchParams();
        searchParams.setUniqueKey(key);

        return selectOne(searchParams);
    }
}
