package net.guerlab.smart.article.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 简单文章
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "article_article")
public class SimpleArticle extends BaseOrderEntity<SimpleArticle> implements DefaultConvertDTO<ArticleDTO> {

    /**
     * 文章ID
     */
    @Id
    private Long articleId;

    /**
     * 唯一key
     */
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @Column(name = "articleCategoryId", nullable = false)
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @Column(name = "articleCategoryName", nullable = false)
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    private String articleCategoryType;

    /**
     * 标题
     */
    @Column(name = "title", nullable = false)
    private String title;

    /**
     * 封面URL
     */
    private String coverUrl;

    /**
     * 简介
     */
    private String synopsis;

    /**
     * 新建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @Column(name = "updateTime", nullable = false)
    private LocalDateTime updateTime;

    /**
     * 原文链接
     */
    @Column(name = "originalLink", nullable = false)
    private String originalLink;
}
