package net.guerlab.smart.article.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 文章分类
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "article_category")
public class ArticleCategory extends BaseOrderEntity<ArticleCategory> implements DefaultConvertDTO<ArticleCategoryDTO> {

    /**
     * 默认文章分类类型
     */
    public static final String DEFAULT_ARTICLE_CATEGORY_TYPE = "general";

    /**
     * 文章分类ID
     */
    @Id
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @Column(name = "articleCategoryName", nullable = false)
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @Column(name = "articleCategoryType", nullable = false)
    private String articleCategoryType;

    /**
     * 封面URL
     */
    @Column(name = "coverUrl", nullable = false)
    private String coverUrl;

    /**
     * 上级ID
     */
    @Column(name = "parentId", nullable = false, updatable = false)
    private Long parentId;

    /**
     * 启用标志
     */
    @Column(name = "enabled", nullable = false)
    private Boolean enabled;
}
