package net.guerlab.smart.article.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 文章
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "article_article")
public class Article extends BaseOrderEntity<Article> implements DefaultConvertDTO<ArticleDTO> {

    /**
     * 文章ID
     */
    @Id
    private Long articleId;

    /**
     * 唯一key
     */
    @Column(name = "uniqueKey", updatable = false)
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @Column(name = "articleCategoryId", nullable = false)
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @Column(name = "articleCategoryName", nullable = false)
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    private String articleCategoryType;

    /**
     * 标题
     */
    @Column(name = "title", nullable = false)
    private String title;

    /**
     * 封面URL
     */
    private String coverUrl;

    /**
     * 作者
     */
    private String author;

    /**
     * 发布时间
     */
    @Column(name = "releaseTime", nullable = false)
    private LocalDateTime releaseTime;

    /**
     * 简介
     */
    private String synopsis;

    /**
     * 内容
     */
    private String content;

    /**
     * 已发布标志
     */
    @Column(name = "published", nullable = false)
    private Boolean published;

    /**
     * 原文链接
     */
    private String originalLink;

    /**
     * 总是跳转标志
     */
    @Column(name = "alwaysRedirect", nullable = false)
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    @Column(name = "publishType", nullable = false)
    private PublishType publishType;

    /**
     * 计划发布时间
     */
    private LocalDateTime planPublishTime;

    /**
     * 实际发布时间
     */
    private LocalDateTime publishTime;

    /**
     * 新建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @Column(name = "updateTime", nullable = false)
    private LocalDateTime updateTime;
}
