package net.guerlab.smart.article.service.crons;

import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 文章计划任务
 *
 * @author guer
 */
@Component
public class ArticleCron {

    private ArticleService service;

    /**
     * 发布计划
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void publish() {
        LocalDateTime now = LocalDateTime.now();
        ArticleSearchParams searchParams = new ArticleSearchParams();
        searchParams.setPublishType(PublishType.TIMING);
        searchParams.setPublished(false);
        searchParams.setPlanPublishTimeEndWith(now);

        Article update = new Article();
        update.setPublished(true);
        update.setPublishTime(now);

        service.updateByExampleSelective(update, service.getExample(searchParams));
    }

    @Autowired
    public void setService(ArticleService service) {
        this.service = service;
    }
}
