/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章配置搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "ArticleConfigSearchParams", description = "文章配置搜索参数")
public class ArticleConfigSearchParams extends AbstractSearchParams {

    /**
     * 配置key
     */
    @Schema(description = "配置key")
    private String configKey;

    /**
     * 配置key列表
     */
    @Schema(description = "配置key列表")
    @Column(name = "configKey")
    @SearchModel(SearchModelType.IN)
    private Collection<String> configKeys;

}
