/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章分类搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "ArticleCategorySearchParams", description = "文章分类搜索参数")
public class ArticleCategorySearchParams extends OrderSearchParams {

    /**
     * 文章分类ID
     */
    @Schema(description = "文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类ID集合
     */
    @Schema(description = "文章分类ID集合")
    @SearchModel(SearchModelType.IN)
    @Column(name = "articleCategoryId")
    private Collection<Long> articleCategoryIds;

    /**
     * 文章分类类型
     */
    @Schema(description = "文章分类类型")
    private String articleCategoryType;

    /**
     * 上级ID
     */
    @Schema(description = "上级ID")
    private Long parentId;

    /**
     * 启用标志
     */
    @Schema(description = "启用标志")
    private Boolean enabled;

    /**
     * 显示标志
     */
    @Schema(description = "显示标志")
    private Boolean display;
}
