/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderTreeEntity;

/**
 * 文章分类
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "ArticleCategoryDTO", description = "文章分类")
public class ArticleCategoryDTO extends BaseOrderTreeEntity<ArticleCategoryDTO> {

    /**
     * 文章分类ID
     */
    @Schema(description = "文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @Schema(description = "文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @Schema(description = "文章分类类型")
    private String articleCategoryType;

    /**
     * 封面URL
     */
    @Schema(description = "封面URL")
    private String coverUrl;

    /**
     * 上级ID
     */
    @Schema(description = "上级ID")
    private Long parentId;

    /**
     * 启用标志
     */
    @Schema(description = "启用标志")
    private Boolean enabled;

    /**
     * 显示标志
     */
    @Schema(description = "显示标志")
    private Boolean display;

    /**
     * 列表页类型
     */
    @Schema(description = "列表页类型")
    private String listPageType;

    /**
     * 详情页类型
     */
    @Schema(description = "详情页类型")
    private String detailPageType;

    @Override
    public Long id() {
        return articleCategoryId;
    }

    @Override
    public Long parentId() {
        return parentId;
    }
}
