/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.searchparams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.OrderByIndex;
import net.guerlab.spring.searchparams.OrderByType;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 文章搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "ArticleSearchParams", description = "文章搜索参数")
public class ArticleSearchParams extends OrderSearchParams {

    /**
     * 文章ID
     */
    @Schema(description = "文章ID")
    private Long articleId;

    /**
     * 文章ID列表
     */
    @Schema(description = "文章ID列表")
    @Column(name = "articleId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleIds;

    /**
     * 唯一key
     */
    @Schema(description = "唯一key")
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @Schema(description = "文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类类型
     */
    @Schema(description = "文章分类类型")
    private String articleCategoryType;

    /**
     * 标题关键字
     */
    @Schema(description = "标题关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "title")
    private String titleLike;

    /**
     * 是否有封面
     */
    @Schema(description = "是否有封面")
    private Boolean hasCoverUrl;

    /**
     * 已发布标志
     */
    @Schema(description = "已发布标志")
    private Boolean published;

    /**
     * 总是跳转标志
     */
    @Schema(description = "总是跳转标志")
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    @Schema(description = "发布方式")
    private PublishType publishType;

    /**
     * 计划发布时间结束范围
     */
    @Schema(hidden = true)
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    @Column(name = "planPublishTime")
    @JsonIgnore
    private LocalDateTime planPublishTimeEndWith;

    /**
     * 包含附件标志
     */
    @Schema(description = "包含附件标志")
    private Boolean hasAttachment;

    /**
     * 审核状态
     */
    @Schema(description = "审核状态")
    private AuditStatus auditStatus;

    /**
     * 查询分类信息
     */
    @Schema(description = "查询分类信息")
    @SearchModel(SearchModelType.IGNORE)
    private Boolean queryCategory;

    /**
     * 发布时间排序方式
     */
    @Schema(description = "发布时间排序方式")
    @Column(name = "releaseTime")
    @OrderByIndex(1)
    private OrderByType releaseTimeOrderByType;

    /**
     * 新建时间排序方式
     */
    @Schema(description = "新建时间排序方式")
    @Column(name = "createTime")
    @OrderByIndex(2)
    private OrderByType createTimeOrderByType;

    /**
     * 更新时间排序方式
     */
    @Schema(description = "更新时间排序方式")
    @Column(name = "updateTime")
    @OrderByIndex(3)
    private OrderByType updateTimeOrderByType;

}
