/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.searchparams;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章分类映射搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "ArticleCategoryMappingSearchParams", description = "文章分类映射搜索参数")
public class ArticleCategoryMappingSearchParams extends AbstractSearchParams {

    /**
     * 文章ID
     */
    @Schema(description = "文章ID")
    private Long articleId;

    /**
     * 文章ID列表
     */
    @Schema(description = "文章ID列表")
    @Column(name = "articleId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleIds;

    /**
     * 文章分类ID
     */
    @Schema(description = "文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类ID列表
     */
    @Schema(description = "文章分类ID列表")
    @Column(name = "articleCategoryId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleCategoryIds;
}
