/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.article.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.eneity.Attachments;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.domain.MultiId;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;

import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 文章
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "ArticleDTO", description = "文章")
public class ArticleDTO extends BaseOrderEntity<ArticleDTO> {

    /**
     * 文章ID
     */
    @Schema(description = "文章ID")
    private Long articleId;

    /**
     * 唯一key
     */
    @Schema(description = "唯一key")
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @Schema(description = "文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @Schema(description = "文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @Schema(description = "文章分类类型")
    private String articleCategoryType;

    /**
     * 次要文章分类ID列表
     */
    @Schema(description = "次要文章分类ID列表")
    private MultiId secondaryArticleCategoryIds;

    /**
     * 文章分类ID列表
     */
    @Schema(description = "文章分类ID列表")
    private MultiId articleCategoryIds;

    /**
     * 标题
     */
    @Schema(description = "标题")
    private String title;

    /**
     * seo-关键词
     */
    @Schema(description = "seo-关键词")
    private String keywords;

    /**
     * seo-页面描述
     */
    @Schema(description = "seo-页面描述")
    private String description;

    /**
     * 封面URL
     */
    @Schema(description = "封面URL")
    private String coverUrl;

    /**
     * 是否有封面
     */
    @Schema(description = "是否有封面")
    private Boolean hasCoverUrl;

    /**
     * 作者
     */
    @Schema(description = "作者")
    private String author;

    /**
     * 发布时间
     */
    @Schema(description = "发布时间")
    private LocalDateTime releaseTime;

    /**
     * 简介
     */
    @Schema(description = "简介")
    private String synopsis;

    /**
     * 内容
     */
    @Schema(description = "内容")
    private String content;

    /**
     * 已发布标志
     */
    @Schema(description = "已发布标志")
    private Boolean published;

    /**
     * 原文链接
     */
    @Schema(description = "原文链接")
    private String originalLink;

    /**
     * 总是跳转标志
     */
    @Schema(description = "总是跳转标志")
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    @Schema(description = "发布方式")
    private PublishType publishType;

    /**
     * 计划发布时间
     */
    @Schema(description = "计划发布时间")
    private LocalDateTime planPublishTime;

    /**
     * 实际发布时间
     */
    @Schema(description = "实际发布时间")
    private LocalDateTime publishTime;

    /**
     * 新建时间
     */
    @Schema(description = "新建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    private LocalDateTime updateTime;

    /**
     * 附件列表
     */
    @Schema(description = "附件列表")
    private Attachments attachments;

    /**
     * 包含附件标志
     */
    @Schema(description = "包含附件标志")
    private Boolean hasAttachment;

    /**
     * 审核状态
     */
    @Schema(description = "审核状态")
    private AuditStatus auditStatus;

    /**
     * 阅读量
     */
    @Schema(description = "阅读量")
    private Long viewNumber;

    /**
     * 文章分类列表
     */
    @Schema(description = "文章分类列表")
    private Collection<ArticleCategoryDTO> categories;
}
