package net.guerlab.smart.article.core.searchparams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.OrderByIndex;
import net.guerlab.spring.searchparams.OrderByType;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 文章搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("文章搜索参数")
public class ArticleSearchParams extends OrderSearchParams {

    /**
     * 文章ID
     */
    @ApiModelProperty("文章ID")
    private Long articleId;

    /**
     * 文章ID列表
     */
    @ApiModelProperty("文章ID列表")
    @Column(name = "articleId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleIds;

    /**
     * 唯一key
     */
    @ApiModelProperty("唯一key")
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;

    /**
     * 标题关键字
     */
    @ApiModelProperty("标题关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "title")
    private String titleLike;

    /**
     * 是否有封面
     */
    @ApiModelProperty("是否有封面")
    private Boolean hasCoverUrl;

    /**
     * 已发布标志
     */
    @ApiModelProperty("已发布标志")
    private Boolean published;

    /**
     * 总是跳转标志
     */
    @ApiModelProperty("总是跳转标志")
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    @ApiModelProperty("发布方式")
    private PublishType publishType;

    /**
     * 计划发布时间结束范围
     */
    @ApiModelProperty(hidden = true)
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    @Column(name = "planPublishTime")
    @JsonIgnore
    private LocalDateTime planPublishTimeEndWith;

    /**
     * 包含附件标志
     */
    @ApiModelProperty("包含附件标志")
    private Boolean hasAttachment;

    /**
     * 审核状态
     */
    @ApiModelProperty("审核状态")
    private AuditStatus auditStatus;

    /**
     * 查询分类信息
     */
    @ApiModelProperty("查询分类信息")
    @SearchModel(SearchModelType.IGNORE)
    private Boolean queryCategory;

    /**
     * 发布时间排序方式
     */
    @ApiModelProperty("发布时间排序方式")
    @Column(name = "releaseTime")
    @OrderByIndex(1)
    private OrderByType releaseTimeOrderByType;

    /**
     * 新建时间排序方式
     */
    @ApiModelProperty("新建时间排序方式")
    @Column(name = "createTime")
    @OrderByIndex(2)
    private OrderByType createTimeOrderByType;

    /**
     * 更新时间排序方式
     */
    @ApiModelProperty("更新时间排序方式")
    @Column(name = "updateTime")
    @OrderByIndex(3)
    private OrderByType updateTimeOrderByType;

}
