package net.guerlab.smart.article.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章配置搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("文章配置搜索参数")
public class ArticleConfigSearchParams extends AbstractSearchParams {

    /**
     * 配置key
     */
    @ApiModelProperty("配置key")
    private String configKey;

    /**
     * 配置key列表
     */
    @ApiModelProperty("配置key列表")
    @Column(name = "configKey")
    @SearchModel(SearchModelType.IN)
    private Collection<String> configKeys;

}
