package net.guerlab.smart.article.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章分类映射搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("文章分类映射搜索参数")
public class ArticleCategoryMappingSearchParams extends AbstractSearchParams {

    /**
     * 文章ID
     */
    @ApiModelProperty("文章ID")
    private Long articleId;

    /**
     * 文章ID列表
     */
    @ApiModelProperty("文章ID列表")
    @Column(name = "articleId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleIds;

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类ID列表
     */
    @ApiModelProperty("文章分类ID列表")
    @Column(name = "articleCategoryId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> articleCategoryIds;
}
