package net.guerlab.smart.article.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderTreeEntity;

/**
 * 文章分类
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("文章分类")
public class ArticleCategoryDTO extends BaseOrderTreeEntity<ArticleCategoryDTO> {

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @ApiModelProperty("文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;

    /**
     * 封面URL
     */
    @ApiModelProperty("封面URL")
    private String coverUrl;

    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    private Long parentId;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enabled;

    @Override
    public Long id() {
        return articleCategoryId;
    }

    @Override
    public Long parentId() {
        return parentId;
    }
}
