package net.guerlab.smart.article.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;

import java.time.LocalDateTime;

/**
 * 文章
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("文章")
public class ArticleDTO extends BaseOrderEntity<ArticleDTO> {

    /**
     * 文章ID
     */
    @ApiModelProperty("文章ID")
    private Long articleId;

    /**
     * 唯一key
     */
    @ApiModelProperty("唯一key")
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @ApiModelProperty("文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;

    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 封面URL
     */
    @ApiModelProperty("封面URL")
    private String coverUrl;

    /**
     * 作者
     */
    @ApiModelProperty("作者")
    private String author;

    /**
     * 发布时间
     */
    @ApiModelProperty("发布时间")
    private LocalDateTime releaseTime;

    /**
     * 简介
     */
    @ApiModelProperty("简介")
    private String synopsis;

    /**
     * 内容
     */
    @ApiModelProperty("内容")
    private String content;

    /**
     * 已发布标志
     */
    @ApiModelProperty("已发布标志")
    private Boolean published;

    /**
     * 原文链接
     */
    @ApiModelProperty("原文链接")
    private String originalLink;

    /**
     * 总是跳转标志
     */
    @ApiModelProperty("总是跳转标志")
    private Boolean alwaysRedirect;

    /**
     * 发布方式
     */
    @ApiModelProperty("发布方式")
    private PublishType publishType;

    /**
     * 计划发布时间
     */
    @ApiModelProperty("计划发布时间")
    private LocalDateTime planPublishTime;

    /**
     * 实际发布时间
     */
    @ApiModelProperty("实际发布时间")
    private LocalDateTime publishTime;

    /**
     * 新建时间
     */
    @ApiModelProperty("新建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;
}
