package net.guerlab.smart.article.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.OrderByIndex;
import net.guerlab.spring.searchparams.OrderByType;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 文章搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("文章搜索参数")
public class ArticleSearchParams extends OrderSearchParams {

    /**
     * 文章ID
     */
    @ApiModelProperty("文章ID")
    private Long articleId;

    /**
     * 唯一key
     */
    @ApiModelProperty("唯一key")
    private String uniqueKey;

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;

    /**
     * 标题关键字
     */
    @ApiModelProperty("标题关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "title")
    private String titleLike;

    /**
     * 新建时间排序方式
     */
    @ApiModelProperty("新建时间排序方式")
    @Column(name = "createTime")
    @OrderByIndex(1)
    private OrderByType createTimeOrderByType;

    /**
     * 更新时间排序方式
     */
    @ApiModelProperty("更新时间排序方式")
    @Column(name = "updateTime")
    @OrderByIndex(2)
    private OrderByType updateTimeOrderByType;
}
