package net.guerlab.smart.article.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 文章分类搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("文章分类搜索参数")
public class ArticleCategorySearchParams extends OrderSearchParams {

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类ID集合
     */
    @ApiModelProperty("文章分类ID集合")
    @SearchModel(SearchModelType.IN)
    @Column(name = "articleCategoryId")
    private Collection<Long> articleCategoryIds;

    /**
     * 文章分类名称
     */
    @ApiModelProperty("文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类名称关键字
     */
    @ApiModelProperty("文章分类名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "articleCategoryName")
    private String articleCategoryNameLike;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;
}
