package net.guerlab.smart.article.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;

/**
 * 文章分类
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("文章分类")
public class ArticleCategoryDTO extends BaseOrderEntity<ArticleCategoryDTO> {

    /**
     * 文章分类ID
     */
    @ApiModelProperty("文章分类ID")
    private Long articleCategoryId;

    /**
     * 文章分类名称
     */
    @ApiModelProperty("文章分类名称")
    private String articleCategoryName;

    /**
     * 文章分类类型
     */
    @ApiModelProperty("文章分类类型")
    private String articleCategoryType;

    /**
     * 封面URL
     */
    @ApiModelProperty("封面URL")
    private String coverUrl;
}
