/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.applicationmarket.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.smart.applicationmarket.core.exception.AppNameInvalidException;
import net.guerlab.smart.applicationmarket.core.exception.AppNameLengthErrorException;
import net.guerlab.smart.applicationmarket.core.exception.DownloadUrlInvalidException;
import net.guerlab.smart.applicationmarket.core.exception.DownloadUrlLengthErrorException;
import net.guerlab.smart.applicationmarket.core.exception.PackageNameInvalidException;
import net.guerlab.smart.applicationmarket.core.exception.PackageNameLengthErrorException;
import net.guerlab.smart.applicationmarket.core.exception.VersionInvalidException;
import net.guerlab.smart.applicationmarket.core.exception.VersionLengthErrorException;
import net.guerlab.smart.applicationmarket.core.searchparams.ApkSearchParams;
import net.guerlab.smart.applicationmarket.service.entity.Apk;
import net.guerlab.smart.applicationmarket.service.mapper.ApkMapper;
import net.guerlab.smart.applicationmarket.service.service.ApkService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ApkServiceImpl
extends BaseServiceImpl<Apk, Long, ApkMapper, ApkSearchParams>
implements ApkService {
    protected void insertBefore(Apk entity) {
        String packageName = StringUtils.trimToNull((String)entity.getPackageName());
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        String version = StringUtils.trimToNull((String)entity.getVersion());
        String downloadUrl = StringUtils.trimToNull((String)entity.getDownloadUrl());
        if (packageName == null) {
            throw new PackageNameInvalidException();
        }
        if (packageName.length() > 100) {
            throw new PackageNameLengthErrorException();
        }
        if (appName == null) {
            throw new AppNameInvalidException();
        }
        if (appName.length() > 255) {
            throw new AppNameLengthErrorException();
        }
        if (version == null) {
            throw new VersionInvalidException();
        }
        if (version.length() > 255) {
            throw new VersionLengthErrorException();
        }
        if (downloadUrl == null) {
            throw new DownloadUrlInvalidException();
        }
        if (downloadUrl.length() > 255) {
            throw new DownloadUrlLengthErrorException();
        }
        entity.setApkId(this.sequence.nextId());
        entity.setPackageName(packageName);
        entity.setAppName(appName);
        entity.setVersion(version);
        entity.setDownloadUrl(downloadUrl);
        if (entity.getDisplay() == null) {
            entity.setDisplay(true);
        }
        entity.setCreatedTime(LocalDateTime.now());
        entity.setUpdateTime(LocalDateTime.now());
    }

    protected void updateBefore(Apk entity) {
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        if (appName != null && appName.length() > 255) {
            throw new AppNameLengthErrorException();
        }
        entity.setAppName(appName);
        String version = StringUtils.trimToNull((String)entity.getVersion());
        if (version != null && version.length() > 255) {
            throw new VersionLengthErrorException();
        }
        entity.setVersion(version);
        String downloadUrl = StringUtils.trimToNull((String)entity.getDownloadUrl());
        if (downloadUrl != null && downloadUrl.length() > 255) {
            throw new DownloadUrlLengthErrorException();
        }
        entity.setDownloadUrl(downloadUrl);
        entity.setUpdateTime(LocalDateTime.now());
    }
}

