package net.guerlab.smart.applicationmarket.service.service.impl;

import net.guerlab.smart.applicationmarket.core.exception.*;
import net.guerlab.smart.applicationmarket.core.searchparams.ApkSearchParams;
import net.guerlab.smart.applicationmarket.service.entity.Apk;
import net.guerlab.smart.applicationmarket.service.mapper.ApkMapper;
import net.guerlab.smart.applicationmarket.service.service.ApkService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * APK版本服务实现
 *
 * @author guer
 */
@Service
public class ApkServiceImpl extends BaseServiceImpl<Apk, Long, ApkMapper, ApkSearchParams> implements ApkService {

    @Override
    protected void insertBefore(Apk entity) {
        String packageName = StringUtils.trimToNull(entity.getPackageName());
        String appName = StringUtils.trimToNull(entity.getAppName());
        String version = StringUtils.trimToNull(entity.getVersion());
        String downloadUrl = StringUtils.trimToNull(entity.getDownloadUrl());

        if (packageName == null) {
            throw new PackageNameInvalidException();
        } else if (packageName.length() > PACKAGE_NAME_MAX_LENGTH) {
            throw new PackageNameLengthErrorException();
        }
        if (appName == null) {
            throw new AppNameInvalidException();
        } else if (appName.length() > APP_NAME_MAX_LENGTH) {
            throw new AppNameLengthErrorException();
        }
        if (version == null) {
            throw new VersionInvalidException();
        } else if (version.length() > VERSION_MAX_LENGTH) {
            throw new VersionLengthErrorException();
        }
        if (downloadUrl == null) {
            throw new DownloadUrlInvalidException();
        } else if (downloadUrl.length() > DOWNLOAD_URL_MAX_LENGTH) {
            throw new DownloadUrlLengthErrorException();
        }

        entity.setApkId(sequence.nextId());
        entity.setPackageName(packageName);
        entity.setAppName(appName);
        entity.setVersion(version);
        entity.setDownloadUrl(downloadUrl);
        if (entity.getDisplay() == null) {
            entity.setDisplay(true);
        }
        entity.setCreatedTime(LocalDateTime.now());
        entity.setUpdateTime(LocalDateTime.now());
    }

    @Override
    protected void updateBefore(Apk entity) {
        String appName = StringUtils.trimToNull(entity.getAppName());
        if (appName != null && appName.length() > APP_NAME_MAX_LENGTH) {
            throw new AppNameLengthErrorException();
        }
        entity.setAppName(appName);

        String version = StringUtils.trimToNull(entity.getVersion());
        if (version != null && version.length() > VERSION_MAX_LENGTH) {
            throw new VersionLengthErrorException();
        }
        entity.setVersion(version);

        String downloadUrl = StringUtils.trimToNull(entity.getDownloadUrl());
        if (downloadUrl != null && downloadUrl.length() > DOWNLOAD_URL_MAX_LENGTH) {
            throw new DownloadUrlLengthErrorException();
        }
        entity.setDownloadUrl(downloadUrl);

        entity.setUpdateTime(LocalDateTime.now());
    }
}
