package net.guerlab.smart.applicationmarket.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import net.guerlab.smart.applicationmarket.core.domain.ApkDTO;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.time.LocalDateTime;

/**
 * APK版本
 *
 * @author guer
 */
@Data
@TableName("applicationMarket_apk")
public class Apk implements DefaultConvert<ApkDTO> {

    /**
     * apk Id
     */
    @TableId
    private Long apkId;

    /**
     * APK包名
     */
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String packageName;

    /**
     * app名称
     */
    private String appName;

    /**
     * 版本
     */
    private String version;

    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 显示标志
     */
    private Boolean display;

    /**
     * 创建时间
     */
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createdTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
