package net.guerlab.smart.applicationmarket.service.service;

import net.guerlab.smart.applicationmarket.service.entity.Apk;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * APK版本服务
 *
 * @author guer
 */
public interface ApkService extends BaseService<Apk, Long> {

    /**
     * 包名最大长度
     */
    int PACKAGE_NAME_MAX_LENGTH = 100;

    /**
     * 应用名最大长度
     */
    int APP_NAME_MAX_LENGTH = 255;

    /**
     * 版本号最大长度
     */
    int VERSION_MAX_LENGTH = 255;

    /**
     * 下载链接最大长度
     */
    int DOWNLOAD_URL_MAX_LENGTH = 255;

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<Apk> getEntityClass() {
        return Apk.class;
    }
}
