package net.guerlab.smart.applicationmarket.service.entity;

import lombok.Data;
import net.guerlab.smart.applicationmarket.core.domain.ApkDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * APK版本
 *
 * @author guer
 */
@Data
@Table(name = "applicationMarket_apk")
public class Apk implements DefaultConvertDTO<ApkDTO> {

    /**
     * apk Id
     */
    @Id
    private Long apkId;

    /**
     * APK包名
     */
    @Column(name = "packageName", nullable = false, updatable = false)
    private String packageName;

    /**
     * app名称
     */
    private String appName;

    /**
     * 版本
     */
    private String version;

    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 显示标志
     */
    @Column(name = "display", nullable = false)
    private Boolean display;

    /**
     * 创建时间
     */
    @Column(name = "createdTime", nullable = false, updatable = false)
    private LocalDateTime createdTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
