/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.spring.upload.aliyun.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import net.guerlab.spring.upload.aliyun.oss.AliyunOssHandler;
import net.guerlab.spring.upload.aliyun.oss.AliyunOssProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AliyunOssProperties.class})
public class AliyunOssAutoConfigure {
    @Autowired
    private AliyunOssProperties properties;

    @RefreshScope
    @Bean
    public OSS ossClient() {
        ClientConfiguration config = this.properties.getClientConfig();
        String endpoint = this.properties.getEndpoint();
        String accessKeyId = this.properties.getAccessKeyId();
        String accessKeySecret = this.properties.getAccessKeySecret();
        DefaultCredentialProvider credsProvider = new DefaultCredentialProvider(accessKeyId, accessKeySecret);
        if (config == null) {
            config = new ClientConfiguration();
        }
        return new OSSClient(endpoint, (CredentialsProvider)credsProvider, config);
    }

    @Bean
    public AliyunOssHandler aliyunOssHandler(OSS ossClient, AliyunOssProperties properties) {
        return new AliyunOssHandler(ossClient, properties);
    }
}

