/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.provider;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.guerlab.cloud.commons.api.QueryApi;
import net.guerlab.cloud.commons.entity.IBaseEntity;
import net.guerlab.cloud.core.result.Pageable;
import net.guerlab.cloud.core.util.SpringUtils;
import net.guerlab.cloud.searchparams.SearchParams;
import net.guerlab.cloud.web.provider.GlobalBeforeFindHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class BaseQueryController<E extends IBaseEntity, SP extends SearchParams, A extends QueryApi<E, SP>, V> {
    private static final Logger log = LoggerFactory.getLogger(BaseQueryController.class);
    protected final A api;

    public BaseQueryController(A api) {
        this.api = api;
    }

    protected abstract V convert(E var1);

    @Nullable
    @GetMapping(value={"/{id}"})
    @Operation(summary="\u901a\u8fc7Id\u67e5\u8be2\u5355\u4e00\u7ed3\u679c", security={@SecurityRequirement(name="Authorization")})
    public V selectById(@Parameter(description="ID", required=true) @PathVariable(value="id") Long id, @Nullable SP searchParams) {
        IBaseEntity entity = this.getApi().selectById(id);
        if (entity == null) {
            throw this.nullPointException();
        }
        this.entityCheck(entity);
        V vo = this.convert(entity);
        this.afterFind(Collections.singletonList(vo), searchParams);
        return vo;
    }

    @Nullable
    @PostMapping(value={"/search/one"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e00\u7ed3\u679c", security={@SecurityRequirement(name="Authorization")})
    public V selectOne(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP searchParams) {
        IBaseEntity entity = this.beforeFind(searchParams) ? this.getApi().selectOne(searchParams) : null;
        if (entity == null) {
            throw this.nullPointException();
        }
        this.entityCheck(entity);
        V vo = this.convert(entity);
        this.afterFind(Collections.singletonList(vo), searchParams);
        return vo;
    }

    protected void entityCheck(E entity) {
    }

    protected RuntimeException nullPointException() {
        return new NullPointerException();
    }

    @PostMapping(value={"/search/list"})
    @Operation(summary="\u67e5\u8be2\u5217\u8868", security={@SecurityRequirement(name="Authorization")})
    public List<V> selectList(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP searchParams) {
        if (!this.beforeFind(searchParams)) {
            return Collections.emptyList();
        }
        this.invokeGlobalBeforeFindHook(searchParams);
        List list = this.getApi().selectList(searchParams);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> result = list.stream().map(this::convert).toList();
        this.afterFind(result, searchParams);
        return result;
    }

    @PostMapping(value={"/search/page"})
    @Operation(summary="\u67e5\u8be2\u5206\u9875\u5217\u8868", security={@SecurityRequirement(name="Authorization")})
    public Pageable<V> selectPage(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP searchParams, @Parameter(description="\u5206\u9875ID") @RequestParam(name="pageId", defaultValue="1", required=false) int pageId, @Parameter(description="\u5206\u9875\u5c3a\u5bf8") @RequestParam(name="pageSize", defaultValue="10", required=false) int pageSize) {
        if (!this.beforeFind(searchParams)) {
            return Pageable.empty();
        }
        this.invokeGlobalBeforeFindHook(searchParams);
        Pageable result = this.getApi().selectPage(searchParams, pageId, pageSize);
        List list = result.getList() != null ? result.getList().stream().map(this::convert).toList() : Collections.emptyList();
        this.afterFind(list, searchParams);
        Pageable voResult = new Pageable();
        voResult.setCount(result.getCount());
        voResult.setList(list);
        voResult.setCurrentPageId(result.getCurrentPageId());
        voResult.setMaxPageId(result.getMaxPageId());
        voResult.setPageSize(result.getPageSize());
        return voResult;
    }

    @PostMapping(value={"/search/count"})
    @Operation(summary="\u67e5\u8be2\u603b\u8bb0\u5f55\u6570", security={@SecurityRequirement(name="Authorization")})
    public long selectCount(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP searchParams) {
        if (!this.beforeFind(searchParams)) {
            return 0L;
        }
        this.invokeGlobalBeforeFindHook(searchParams);
        return this.getApi().selectCount(searchParams);
    }

    private void invokeGlobalBeforeFindHook(SP searchParams) {
        for (GlobalBeforeFindHook handler : SpringUtils.getBeans(GlobalBeforeFindHook.class)) {
            if (!handler.accept((SearchParams)searchParams)) continue;
            handler.handler((SearchParams)searchParams);
        }
    }

    protected boolean beforeFind(SP searchParams) {
        return true;
    }

    protected void afterFind(Collection<V> list, @Nullable SP searchParams) {
    }

    public A getApi() {
        return this.api;
    }
}

