/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.provider;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collections;
import net.guerlab.cloud.commons.api.ManageApi;
import net.guerlab.cloud.commons.entity.BaseEntity;
import net.guerlab.cloud.log.annotation.Log;
import net.guerlab.cloud.searchparams.SearchParams;
import net.guerlab.cloud.web.provider.BaseQueryController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseManageController<E extends BaseEntity, SP extends SearchParams, A extends ManageApi<E, SP>, V>
extends BaseQueryController<E, SP, A, V> {
    private static final Logger log = LoggerFactory.getLogger(BaseManageController.class);

    public BaseManageController(A api) {
        super(api);
    }

    @Log(value="method.insert")
    @PostMapping
    @Operation(summary="\u65b0\u589e\u5b9e\u4f53", security={@SecurityRequirement(name="Authorization")})
    public V insert(@RequestBody E entity) {
        entity = (BaseEntity)((ManageApi)this.getApi()).insert(entity);
        Object vo = this.convert(entity);
        this.afterFind(Collections.singletonList(vo), null);
        return vo;
    }

    @Log(value="method.updateById")
    @PostMapping(value={"/updateById"})
    @Operation(summary="\u6839\u636eId\u7f16\u8f91\u6570\u636e", security={@SecurityRequirement(name="Authorization")})
    public V updateById(@RequestBody E entity) {
        Long id = entity.getId();
        if (id == null) {
            throw this.nullPointException();
        }
        ((ManageApi)this.getApi()).updateById(entity);
        Object vo = this.selectById(id, null);
        if (vo == null) {
            throw this.nullPointException();
        }
        return vo;
    }

    @Log(value="method.deleteById")
    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u6839\u636eId\u5220\u9664\u6570\u636e", security={@SecurityRequirement(name="Authorization")})
    public void deleteById(@Parameter(description="ID", required=true) @PathVariable(value="id") Long id) {
        ((ManageApi)this.getApi()).deleteById(id);
    }

    @Log(value="method.delete")
    @DeleteMapping
    @Operation(summary="\u6839\u636e\u641c\u7d22\u53c2\u6570\u5220\u9664\u6570\u636e", security={@SecurityRequirement(name="Authorization")})
    public void delete(@Parameter(description="\u641c\u7d22\u53c2\u6570", required=true) @RequestBody SP searchParams) {
        ((ManageApi)this.getApi()).delete(searchParams);
    }
}

