/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.context.core;

import java.util.List;
import java.util.ServiceLoader;
import net.guerlab.cloud.context.core.ContextAttributes;
import net.guerlab.cloud.context.core.ObjectContextAttributesHolder;
import org.springframework.lang.Nullable;

public final class ContextAttributesHolder {
    private static final InheritableThreadLocal<ContextAttributes> THREAD_LOCAL = new InheritableThreadLocal<ContextAttributes>(){

        @Override
        protected ContextAttributes initialValue() {
            return new ContextAttributes();
        }
    };
    private static final List<ObjectContextAttributesHolder> OBJECT_CONTEXT_ATTRIBUTES_HOLDERS = ServiceLoader.load(ObjectContextAttributesHolder.class).stream().map(ServiceLoader.Provider::get).toList();

    private ContextAttributesHolder() {
    }

    public static ContextAttributes get() {
        return (ContextAttributes)THREAD_LOCAL.get();
    }

    public static ContextAttributes get(@Nullable Object object) {
        ContextAttributes contextAttributes = null;
        if (object != null) {
            contextAttributes = OBJECT_CONTEXT_ATTRIBUTES_HOLDERS.stream().filter(holder -> holder.accept(object)).map(holder -> holder.get(object)).findFirst().orElse(null);
        }
        if (contextAttributes == null) {
            contextAttributes = (ContextAttributes)THREAD_LOCAL.get();
        }
        return contextAttributes;
    }

    public static void set(ContextAttributes contextAttributes, @Nullable Object object) {
        if (object == null) {
            THREAD_LOCAL.set(contextAttributes);
        } else {
            List<ObjectContextAttributesHolder> holders = OBJECT_CONTEXT_ATTRIBUTES_HOLDERS.stream().filter(holder -> holder.accept(object)).toList();
            if (holders.isEmpty()) {
                THREAD_LOCAL.set(contextAttributes);
            } else {
                holders.forEach(holder -> holder.set(object, contextAttributes));
            }
        }
    }

    public static void set(ContextAttributes contextAttributes) {
        THREAD_LOCAL.set(contextAttributes);
    }
}

