/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.cloud.banner.core.searchparams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.cloud.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.Column;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import java.time.LocalDateTime;

/**
 * Banner搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "BannerSearchParams", description = "Banner搜索参数")
public class BannerSearchParams extends OrderSearchParams {

    /**
     * BannerID
     */
    @Schema(description = "BannerID")
    private Long bannerId;

    /**
     * Banner名称关键字
     */
    @Schema(description = "Banner名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "bannerName")
    private String bannerNameLike;

    /**
     * Banner分组Key
     */
    @Schema(description = "Banner分组Key")
    private String bannerGroupKey;

    /**
     * 展示标志
     */
    @Schema(description = "展示标志")
    private Boolean display;

    /**
     * 启用区域范围限制标志
     */
    @Schema(description = "启用区域范围限制标志")
    private Boolean enableRegionScopeLimit;

    /**
     * 地区ID
     */
    @Schema(description = "地区ID")
    @SearchModel(value = SearchModelType.CUSTOM_SQL, sql = "(`enableRegionScopeLimit` = FALSE OR JSON_SEARCH(`regionIds`, 'one', ?) IS NOT NULL)")
    private Long regionId;

    /**
     * 展示标志
     */
    @Schema(hidden = true)
    @SearchModel(value = SearchModelType.CUSTOM_SQL, sql = "`displayStartTime` <= ? AND `displayEndTime` >= ?")
    @JsonIgnore
    private LocalDateTime currentTime;
}
