/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.cloud.banner.core.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.cloud.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.Column;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import java.util.Collection;

/**
 * Banner分组搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "BannerGroupSearchParams", description = "Banner分组搜索参数")
public class BannerGroupSearchParams extends OrderSearchParams {

    /**
     * Banner分组Key
     */
    @Schema(description = "Banner分组Key")
    private String bannerGroupKey;

    /**
     * Banner分组Key列表
     */
    @Schema(description = "Banner分组Key列表")
    @SearchModel(SearchModelType.IN)
    @Column(name = "bannerGroupKey")
    private Collection<String> bannerGroupKeys;

    /**
     * Banner分组名称
     */
    @Schema(description = "Banner分组名称")
    private String bannerGroupName;

    /**
     * Banner分组名称关键字
     */
    @Schema(description = "Banner分组名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "bannerGroupName")
    private String bannerGroupNameLike;
}
