/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.cloud.banner.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.cloud.commons.domain.MultiId;
import net.guerlab.cloud.commons.entity.BaseOrderEntity;

import java.time.LocalDateTime;

/**
 * Banner
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "BannerDTO", description = "Banner")
public class BannerDTO extends BaseOrderEntity<BannerDTO> {

    /**
     * BannerID
     */
    @Schema(description = "BannerID")
    private Long bannerId;

    /**
     * Banner名称
     */
    @Schema(description = "Banner名称")
    private String bannerName;

    /**
     * Banner分组Key
     */
    @Schema(description = "Banner分组Key")
    private String bannerGroupKey;

    /**
     * Banner分组名称
     */
    @Schema(description = "Banner分组名称")
    private String bannerGroupName;

    /**
     * 封面地址
     */
    @Schema(description = "封面地址")
    private String coverUrl;

    /**
     * 展示标志
     */
    @Schema(description = "展示标志")
    private Boolean display;

    /**
     * 展示开始时间
     */
    @Schema(description = "展示开始时间")
    private LocalDateTime displayStartTime;

    /**
     * 展示结束时间
     */
    @Schema(description = "展示结束时间")
    private LocalDateTime displayEndTime;

    /**
     * banner分组配置表
     */
    @Schema(description = "banner分组配置表")
    private BannerGroupProperties properties;

    /**
     * 启用区域范围限制标志
     */
    @Schema(description = "启用区域范围限制标志")
    private Boolean enableRegionScopeLimit;

    /**
     * 展示地区ID列表
     */
    @Schema(description = "展示地区ID列表")
    private MultiId regionIds;
}
