/*
 * Copyright 2018-2022 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.gnu.org/licenses/lgpl-3.0.html
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.cloud.banner.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * banner分组配置
 *
 * @author guer
 */
@Data
@Schema(name = "BannerGroupProperty", description = "banner分组配置")
public class BannerGroupProperty {

    /**
     * 参数key
     */
    @Schema(description = "参数key")
    private String key;

    /**
     * 参数名称
     */
    @Schema(description = "参数名称")
    private String name;

    /**
     * 参数值
     */
    @Schema(description = "参数值")
    private String value;
}
