/*
 * Copyright 2018-2022 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.gnu.org/licenses/lgpl-3.0.html
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.cloud.banner.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.cloud.commons.entity.BaseOrderEntity;

/**
 * Banner分组
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Schema(name = "BannerGroupDTO", description = "Banner分组")
public class BannerGroupDTO extends BaseOrderEntity<BannerGroupDTO> {

    /**
     * Banner分组Key
     */
    @Schema(description = "Banner分组Key")
    private String bannerGroupKey;

    /**
     * Banner分组名称
     */
    @Schema(description = "Banner分组名称")
    private String bannerGroupName;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * banner分组配置表
     */
    @Schema(description = "banner分组配置表")
    private BannerGroupProperties properties;
}
