/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.exceptions.UnableToLoadSourceException;
import org.yaml.snakeyaml.Yaml;

class YmlLoaderImpl
implements SourceLoader {
    private YmlLoaderImpl() {
    }

    public static YmlLoaderImpl getInstance() {
        return SourceLoaderHolder.LOADER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> load(String path) {
        try (FileInputStream is = new FileInputStream(path);){
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load((InputStream)is);
            return map;
        }
        catch (IOException e) {
            throw new UnableToLoadSourceException("Unable to load yaml.", e);
        }
    }

    private static class SourceLoaderHolder {
        private static final YmlLoaderImpl LOADER = new YmlLoaderImpl();

        private SourceLoaderHolder() {
        }
    }
}

