/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.groupadd.yena.common.configuration.api.Source;
import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.api.SourceLoaderFactory;
import net.groupadd.yena.common.configuration.enums.Ext;
import net.groupadd.yena.common.configuration.exceptions.UnsupportedExtensionException;

class SourceImpl
implements Source {
    private final SourceLoaderFactory sourceLoaderFactory;
    private final Set<String> pathSet;
    private final Map<String, Object> sourceMap;
    private final Lock readLock;
    private final Lock writeLock;

    SourceImpl(Map<String, Object> sourceMap, SourceLoaderFactory sourceLoaderFactory, Set<String> pathSet) {
        this.sourceLoaderFactory = sourceLoaderFactory;
        this.pathSet = pathSet;
        this.sourceMap = sourceMap;
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
    }

    private Ext getExtension(String path) {
        int pos = path.lastIndexOf(".");
        if (pos != -1) {
            return Ext.valueOf(path.substring(pos + 1).toUpperCase());
        }
        throw new UnsupportedExtensionException("Unable to get a proper extension with : " + path);
    }

    @Override
    public void init() {
        this.writeLock.lock();
        try {
            this.sourceMap.clear();
            this.pathSet.stream().map(s -> {
                Ext ext = this.getExtension((String)s);
                SourceLoader loader = this.sourceLoaderFactory.create(ext);
                return loader.load((String)s);
            }).forEach(map -> this.sourceMap.putAll((Map<String, Object>)map));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        this.readLock.lock();
        try {
            Object val = this.getPropsValue(this.sourceMap, key);
            if (val == null) {
                val = this.getYmlValue(this.sourceMap, key);
            }
            Object object = val;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Object getPropsValue(Map<String, Object> map, String key) {
        return map.get(key);
    }

    private Object getYmlValue(Map<String, Object> map, String key) {
        if (key == null) {
            return null;
        }
        Map newMap = map;
        Object res = null;
        if (key.length() - 1 == key.lastIndexOf(".")) {
            return null;
        }
        while (key.length() > 0) {
            int pos = key.indexOf(".");
            if (pos == -1) {
                res = newMap.get(key);
                break;
            }
            if (pos == 0) {
                res = null;
                break;
            }
            String k = key.substring(0, pos);
            Object obj = newMap.get(k);
            if (obj instanceof LinkedHashMap) {
                newMap = (Map)obj;
                key = key.substring(pos + 1);
                continue;
            }
            res = obj;
            key = key.substring(pos + 1);
        }
        return res;
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.sourceMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

