/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.groupadd.yena.common.configuration.api.Source;
import net.groupadd.yena.common.configuration.api.SourceLoaderFactory;
import net.groupadd.yena.common.configuration.core.SourceImpl;
import net.groupadd.yena.common.configuration.core.SourceLoaderFactoryImpl;

public class SourceBuilder {
    private final int delay;
    private final TimeUnit timeUnit;
    private final Map<String, Object> map;
    private final SourceLoaderFactory factory;
    private final Set<String> paths;

    private SourceBuilder(Builder builder) {
        this.delay = builder.delay;
        this.timeUnit = builder.timeUnit;
        this.paths = builder.paths;
        this.factory = new SourceLoaderFactoryImpl();
        this.map = new HashMap<String, Object>();
    }

    public Source source() {
        return new SourceImpl(this.map, this.factory, this.paths);
    }

    public int delay() {
        return this.delay;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> paths = new HashSet<String>();
        private int delay = 10;
        private TimeUnit timeUnit = TimeUnit.MINUTES;

        Builder() {
        }

        public Builder path(String path) {
            this.paths.add(path);
            return this;
        }

        public Builder paths(Set<String> paths) {
            this.paths.addAll(paths);
            return this;
        }

        public Builder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public SourceBuilder build() {
            return new SourceBuilder(this);
        }
    }
}

