/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import com.github.drapostolos.typeparser.TypeParser;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.ConfigurationService;
import net.groupadd.yena.common.configuration.api.Source;
import net.groupadd.yena.common.configuration.core.ConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReloadableConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadableConfigurationServiceImpl.class);
    private final Source source;
    private final ScheduledExecutorService service;
    private final int delay;
    private final TimeUnit timeUnit;
    private final Configuration configuration;

    public ReloadableConfigurationServiceImpl(Source source) {
        this(source, 10, TimeUnit.MINUTES);
    }

    public ReloadableConfigurationServiceImpl(Source source, int delay, TimeUnit timeUnit) {
        this.source = source;
        this.service = Executors.newScheduledThreadPool(1);
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.configuration = new ConfigurationImpl(this.source, TypeParser.newBuilder().build());
    }

    @Override
    public void start() {
        LOGGER.info("Reload Service started...");
        this.service.scheduleWithFixedDelay(() -> {
            this.source.init();
            LOGGER.info("Configuration loaded.");
        }, 0L, this.delay, this.timeUnit);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void stop() {
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
        finally {
            this.source.clear();
            LOGGER.info("Reload Service stopped and Configuration cleared...");
        }
    }
}

