/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.exceptions.UnableToLoadSourceException;

class PropertiesLoaderImpl
implements SourceLoader {
    private PropertiesLoaderImpl() {
    }

    public static PropertiesLoaderImpl getInstance() {
        return SourceLoaderHolder.LOADER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> load(String path) {
        try (FileInputStream is = new FileInputStream(path);){
            Properties properties = new Properties();
            properties.load(is);
            Map<String, Object> map = properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue()));
            return map;
        }
        catch (IOException e2) {
            throw new UnableToLoadSourceException("Unable to load properties.", e2);
        }
    }

    private static class SourceLoaderHolder {
        private static final PropertiesLoaderImpl LOADER = new PropertiesLoaderImpl();

        private SourceLoaderHolder() {
        }
    }
}

